unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,
  MainData, Res1, Menus, Unit2;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Panel1: TPanel;
    Image1: TImage;
    Panel2: TPanel;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N5: TMenuItem;
    Panel3: TPanel;
    Label1: TLabel;
    Edit1: TEdit;
    CkBoxStep: TCheckBox;
    CbBoxTime: TComboBox;
    BttStep: TButton;
    CbBoxView: TComboBox;
    Label2: TLabel;
    Label6: TLabel;
    Edit5: TEdit;
    Label7: TLabel;
    Edit6: TEdit;
    CbBoxMove: TComboBox;
    Label8: TLabel;
    N3: TMenuItem;
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CkBoxStepClick(Sender: TObject);
    procedure BttStepClick(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure N5Click(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure Edit4Change(Sender: TObject);
    procedure Edit5Change(Sender: TObject);
    procedure Edit6Change(Sender: TObject);
    procedure N3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure NewEvalution();
    procedure OneStepEvalution();
    procedure StepControl(RqStep : boolean);
    procedure CGenShow();
    //procedure CellEvalution();
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

var ClrNew, ClrMight, ClrOld : TColor;

type TCGen = record
   CMove   : smallint;
   CDiv    : smallint;
   COld    : smallint;
   CYouth  : smallint;
   CMature : smallint;
end;

var CGen : TCGen;

//        
function IndxToPix (RqIndx : integer) : integer;
begin
  Result := PixOnCell * RqIndx;
end;

//       
function PixToIndx (RqPix : integer) : integer;
begin
  Result := RqPix div PixOnCell;
end;

//      
function TestIndx (RqArrBioCell : TArrBioCell; Row, Col : integer) : boolean;
begin
   Result := False;
   if (Row >=  Low(RqArrBioCell)) and
      (Row <= High(RqArrBioCell))
  then
     if (Col >=  Low(RqArrBioCell[Row])) and
        (Col <= High(RqArrBioCell[Row]))
     then Result := True;
end;

//     TEdit     
//       .
function LoadIntFromEdit (RqEdit : TEdit; Min, Max : integer; var OutInt : integer) : boolean;
begin
    Result := False;             //  
    try
      OutInt := StrToInt(RqEdit.Text);
      //   
      //   , :
      RqEdit.Color := clWindow;  //   
      if OutInt < Min
      then begin
          OutInt := Min;
          MessageDlg('MIN.     '+ IntToStr(Min),
               mtInformation, [mbOk], 0);
          RqEdit.Text := IntToStr(Min);
      end;
      if OutInt > Max
      then begin
          OutInt := Max;
          MessageDlg('MAX.     '+ IntToStr(Max),
               mtInformation, [mbOk], 0);
          RqEdit.Text := IntToStr(Max);
      end;
      Result := True;            //  
    except
      //  .  :
      RqEdit.Color := RGB(255,200,200);
    end;
end;

//   
procedure InitArrBioCell (var RqArrBioCell : TArrBioCell; RqImage : Timage);
var Row, Col : integer;
begin
  MaxRowCount := PixToIndx(RqImage.Height);
  MaxColCount := PixToIndx(RqImage.Width);
  SetLength(RqArrBioCell, MaxRowCount);
  for Row := Low(RqArrBioCell) to High(RqArrBioCell)
  do begin
      SetLength(RqArrBioCell[Row], MaxColCount);
      for Col := Low(RqArrBioCell[Row]) to High(RqArrBioCell[Row])
      do FillChar(RqArrBioCell[Row, Col], SizeOF(TBioCell), #0);
  end;
end;

//    
procedure ShowCell (RqArrBioCell : TArrBioCell;
                    Row, Col     : integer;
                    RqColor      : TColor;
                    RqImage      : Timage;
                    RqView       : integer);
var XB, YB : integer;
    wStr   : string;
begin
  if TestIndx (RqArrBioCell, Row, Col)
  then begin
      with RqImage
      do begin
        Canvas.Brush.Style := bsSolid;
        Canvas.Brush.Color := RqColor;
        Canvas.Pen.Color   := RqColor;
        XB := IndxToPix(Col);
        YB := IndxToPix(Row);
        Canvas.Ellipse(XB,YB, XB + PixOnCell,YB + PixOnCell);
        if RqView > 0
        then begin
           if RqArrBioCell[Row, Col].CStat > 0
           then begin
             Canvas.Brush.Style := bsClear;
             case RqView of
             0 : wStr := '';
             1 : wStr := IntToStr(RqArrBioCell[Row, Col].PRes);
             2 : wStr := IntToStr(RqArrBioCell[Row, Col].SRes);
             3 : wStr := IntToStr(RqArrBioCell[Row, Col].MVec);
             else wStr := '';
             end;
             Canvas.TextOut(XB + dXText,YB + dYText, wStr);
           end;
        end;
      end;
  end;
end;

//   
procedure ImageClear (RqImage : TImage);
begin
  with RqImage
  do begin
     Canvas.Brush.Style := bsSolid;
     Canvas.Brush.Color := clBtnFace;
     Canvas.Pen.Color   := clBtnFace;
     Canvas.Rectangle(0,0, Width, Height);
  end;
end;

//      
procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var Row, Col : integer;
begin
  Row := PixToIndx(Y);
  Col := PixToIndx(X);
  if TestIndx (ArrBioCell, Row, Col)
  then begin
     ArrBioCell[Row, Col].CStat := 1;
     ShowCell (ArrBioCell, Row, Col, ClrNew, Image1, CbBoxView.ItemIndex);
  end;
end;



//   
procedure EvolutionStep(var RqArrBioCell : TArrBioCell;
                        RqImage : Timage; RqView, RqMove : TComboBox);
var Row, Col, X, Y : integer;
    fCalc : boolean;
begin
  for Row := Low(RqArrBioCell) to High(RqArrBioCell)
  do begin
      for Col := Low(RqArrBioCell[Row]) to High(RqArrBioCell[Row])
      do begin
      with RqArrBioCell[Row, Col]
      do begin
         fCalc := True;
         if CStat > 0
         then begin
           //   
           if  CStat < CGen.CYouth
           then begin
                //    
                CalcRArea (RqArrBioCell, Row, Col);
                if (RqMove.ItemIndex = 1)
                then begin
                   //   
                   if (PRes > CGen.CMove) and (SRes > 0)
                   then begin
                      X := dMX;
                      Y := dMY;
                      if TestIndx (RqArrBioCell, Row + Y, Col + X)
                      then begin
                        //  
                        PRes := PRes - CGen.CMove;
                        RqArrBioCell[Row + Y, Col + X] := RqArrBioCell[Row, Col];
                        FillChar(RqArrBioCell[Row, Col], SizeOF(TBioCell),#0);
                        ShowCell (RqArrBioCell, Row, Col, clBtnFace, RqImage, RqView.ItemIndex);
                        ShowCell (RqArrBioCell, Row + Y, Col + X, ClrNew, RqImage, RqView.ItemIndex);
                      end;
                   end
                   else begin
                       //  
                       ShowCell (RqArrBioCell, Row, Col, ClrNew, RqImage, RqView.ItemIndex);
                       CStat := CStat + 1;
                   end;
                end
                else begin
                   //  
                   ShowCell (RqArrBioCell, Row, Col, ClrNew, RqImage, RqView.ItemIndex);
                   CStat := CStat + 1;
                end;
                fCalc := False;
           end;

           //    
           if  (CStat < (CGen.CYouth + CGen.CMature)) and fCalc
           then begin
                CalcRArea (RqArrBioCell, Row, Col);
                if PRes > CGen.CDiv
                then begin
                   //      
                   if SRes > 0
                   then begin
                      //       
                      X := dMX;
                      Y := dMY;
                      if TestIndx (RqArrBioCell, Row + Y, Col + X)
                      then begin
                          if (RqArrBioCell[Row + Y, Col + X].CStat = 0)
                          then begin
                             PRes := 0;
                             ShowCell (RqArrBioCell, Row, Col, ClrMight, RqImage, RqView.ItemIndex);
                             //  
                             RqArrBioCell[Row + Y, Col + X].CStat := 1;
                             RqArrBioCell[Row + Y, Col + X].PRes  := 0;
                             ShowCell (RqArrBioCell, Row + Y, Col + X, ClrNew, RqImage, RqView.ItemIndex);
                           end;
                       end
                       else begin
                           PRes := PRes div 2;
                           ShowCell (RqArrBioCell, Row, Col, clRed, RqImage, RqView.ItemIndex);
                       end;
                   end
                   else begin
                      PRes := PRes div 2;
                      ShowCell (RqArrBioCell, Row, Col, ClrMight, RqImage, RqView.ItemIndex);
                   end;
                end
                else ShowCell (RqArrBioCell, Row, Col, ClrMight, RqImage, RqView.ItemIndex);
                CStat := CStat + 1;
                fCalc := False;
           end;

           //  
           if fCalc
           then begin
              SRes := 0;
              MVec := 0;
              PRes := RqArrBioCell[Row, Col].PRes - CGen.COld;
              if PRes > 0
              then begin
                  ShowCell (RqArrBioCell, Row, Col, ClrOld, RqImage, RqView.ItemIndex);
                  CStat := CStat + 1;
              end
              else begin
                  //  
                  FillChar(RqArrBioCell[Row, Col], SizeOF(TBioCell),#0);
                  RqArrBioCell[Row, Col].CStat := 0;
                  ShowCell (RqArrBioCell, Row, Col, clBtnFace, RqImage, RqView.ItemIndex);
              end;
           end;
         end;
      end; // with
      end; // for
  end; // for
end;

//   
procedure TForm1.OneStepEvalution();
begin
  EvolutionStep(ArrBioCell, Image1, CbBoxView, CbBoxMove);
  CCount := CCount + 1;
  Edit1.Text := IntToStr(CCount);
end;

//    
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  OneStepEvalution();
  case CbBoxTime.ItemIndex of
  0 : Timer1.Interval := 100;
  1 : Timer1.Interval := 200;
  2 : Timer1.Interval := 400;
  3 : Timer1.Interval := 800;
  end;
end;

//   
procedure TForm1.BttStepClick(Sender: TObject);
begin
  OneStepEvalution();
end;

//    
procedure TForm1.StepControl(RqStep : boolean);
begin
  if RqStep
  then begin
     //  
     Timer1.Enabled := False;
     CbBoxTime.Visible := False;
     BttStep.Visible := True;
     BttStep.Enabled := True;
  end
  else begin
     //  
     Timer1.Enabled := True;
     BttStep.Enabled := False;
     BttStep.Visible := False;
     CbBoxTime.Visible := True;
  end;
end;

//     
procedure TForm1.CkBoxStepClick(Sender: TObject);
begin
  StepControl(CkBoxStep.Checked);
end;

//    
procedure TForm1.NewEvalution();
begin
  CkBoxStep.Checked := True;
  StepControl(CkBoxStep.Checked);
  CGenShow();
  InitArrBioCell (ArrBioCell, Image1);
  ImageClear (Image1);
  Randomize;
  CCount := 0;
  Edit1.Text := '';
end;

//     
procedure TForm1.N2Click(Sender: TObject);
begin
  NewEvalution();
end;

//   
procedure StartParam();
begin
  //   
  CGen.CMove   := 32;
  CGen.CDiv    := 128;
  CGen.COld    := 4;
  CGen.CYouth  := 16;
  CGen.CMature := 32;
  //  
  ClrNew   := RGB(0,255,200);
  ClrMight := RGB(0,200,200);
  ClrOld   := RGB(0,150,200);
end;

//      
procedure TForm1.FormCreate(Sender: TObject);
begin
  StartParam();
  NewEvalution();
end;

//   
procedure TForm1.N5Click(Sender: TObject);
begin
 Close;
end;

//   
procedure TForm1.CGenShow();
begin
   Edit2.Text := IntToStr(CGen.CMove);
   Edit3.Text := IntToStr(CGen.CDiv);
   Edit4.Text := IntToStr(CGen.COld);
   Edit5.Text := IntToStr(CGen.CYouth);
   Edit6.Text := IntToStr(CGen.CMature);
end;

//   
procedure TForm1.Edit2Change(Sender: TObject);
var wInt : integer;
begin
  if LoadIntFromEdit (Edit2, 4, 64, wInt)
  then CGen.CMove := Abs(wInt);
end;

//    
procedure TForm1.Edit3Change(Sender: TObject);
var wInt : integer;
begin
  if LoadIntFromEdit (Edit3, 16, 800, wInt)
  then CGen.CDiv := Abs(wInt);
end;

//    
procedure TForm1.Edit4Change(Sender: TObject);
var wInt : integer;
begin
  if LoadIntFromEdit (Edit4, 1, 32, wInt)
  then CGen.COld := Abs(wInt);
end;

//     
procedure TForm1.Edit5Change(Sender: TObject);
var wInt : integer;
begin
  if LoadIntFromEdit (Edit5, 1, 30, wInt)
  then CGen.CYouth := Abs(wInt);
end;

//     
procedure TForm1.Edit6Change(Sender: TObject);
var wInt : integer;
begin
  if LoadIntFromEdit (Edit6, 1, 70, wInt)
  then CGen.CMature := Abs(wInt);
end;

//  
procedure TForm1.N3Click(Sender: TObject);
begin
 FormHelp.Show;
end;

end.
